<?php

/**
 *
 * Let's Review API Class
 *
 * @since      1.1.0
 *
 * @package    Let's Review
 * @subpackage lets-review/admin
 */

class Lets_Review_API {

	/**
	 * Get review final score subtitle
	 *
	 * @since    1.1.0
	 */
	public function lets_review_get_final_score_subtitle( $pid = '' ) {
		if ( get_post_meta( $pid, '_lets_review_onoff', true ) != 1 ) {
			return;
		}
		return get_post_meta( $pid, '_lets_review_subtitle', true );
	}

	/**
	 * Get review color
	 *
	 * @since    1.1.0
	 */
	public function lets_review_get_color( $pid = '' ) {
		if ( get_post_meta( $pid, '_lets_review_onoff', true ) != 1 ) {
			return;
		}

		return Lets_Review_Helpers::lets_review_get_accent(
			array(
				'pid' => $pid,
			)
		);
	}

	/**
	 * Get review final score only
	 *
	 * @since    2.0.3
	 */
	public function lets_review_get_final_score_only( $pid = '' ) {
		if ( get_post_meta( $pid, '_lets_review_onoff', true ) != 1 ) {
			return;
		}
		return get_post_meta( $pid, '_lets_review_final_score', true );
	}

	/**
	 * Check if review is on
	 *
	 * @since    1.1.0
	 */
	public function lets_review_get_onoff( $pid = '' ) {

		if ( get_post_meta( $pid, '_lets_review_onoff', true ) == 1 ) {
			return true;
		} else {
			return false;
		}

	}

	/**
	 * Output helper
	 *
	 * @since    2.0
	 */
	public static function lets_review_get_score_box( $pid = '', $args = array(
		'classes' => '',
		'color'   => '',
	) ) {
		if ( get_post_meta( $pid, '_lets_review_onoff', true ) != 1 ) {
			return;
		}
		if ( 10 == get_post_meta( $pid, '_lets_review_type', true ) ) {
			$score = Lets_Review_Blocks::lets_review_comment_averages_final_score( array( 'pid' => $pid ) );
			$score = empty( $score['score'] ) ? '' : $score['score'];
		} else {
			$score_base = get_post_meta( $pid, '_lets_review_final_score', true );
			$score_base = 3 == get_post_meta( $pid, '_lets_review_type', true ) ? get_post_meta( $pid, '_lets_review_user_rating', true ) : $score_base;
			$score      = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
				array(
					'score'     => $score_base,
					'scoreType' => 3 == get_post_meta( $pid, '_lets_review_type', true ) ? 1 : get_post_meta( $pid, '_lets_review_format', true ),
				)
			);
		}

		if ( empty( $score ) ) {
			return;
		}
		$subtitle           = get_post_meta( $pid, '_lets_review_subtitle', true );
		$lets_review_format = get_post_meta( $pid, '_lets_review_format', true );
		$color              = empty( $args['color'] ) ? Lets_Review_Helpers::lets_review_get_accent( array( 'pid' => $pid ) ) : $args['color'];
		$output             = '<div class="lets-review-api-wrap lr-font-h lr-cf lr-api-format-' . (int) $lets_review_format;
		if ( ! empty( $args['show_icons'] ) && $lets_review_format > 2 ) {
			$output .= ' lr-api-has-icons';
		}
		if ( ! empty( $subtitle ) ) {
			$output .= ' lr-api-wrap-has-subtitle';
		}
		$output .= empty( $args['classes'] ) ? '"' : ' ' . esc_attr( $args['classes'] ) . '"';
		if ( ! empty( $color ) ) {
			$output .= ' style="background-color: ' . esc_attr( $color ) . ';"';
		}
		$score_100 = $score['outof100'];
		$api_score = $score_100;
		if ( 2 == $lets_review_format ) {
			$api_score = $score['outof10'];
		} elseif ( $lets_review_format > 2 ) {
			$api_score = $score['outof5'];
		}
		$output .= ' data-api-score="' . floatval( $api_score ) . '"';
		$output .= ' data-api-100="' . (int) $score_100 . '"';
		$output .= ' data-api-format="' . (int) $lets_review_format . '"';
		$output .= '>';
		$output .= '<div class="lets-review-api-score-box">';
		$output .= '<div class="lets-review-final-score">';

		if ( $lets_review_format < 3 || empty( $args['show_icons'] ) ) {
			$output .= $api_score;
		} else {
			$filters   = Lets_Review_Blocks::lets_review_block_filters();
			$icon_i    = get_post_meta( $pid, '_lets_review_custom_icon', true );
			$img_i     = get_post_meta( $pid, '_lets_review_custom_image', true );
			$icon_code = 4 == $lets_review_format ? $icon_i : '<i class="' . $filters['stars'] . '"></i>';
			$icon_code = 5 == $lets_review_format ? wp_get_attachment_image( $img_i, 'thumbnail' ) : $icon_code;
			$output   .= lets_review_sanitize_wp_kses( str_repeat( $icon_code, $filters['icon_quantity'] ) );
			$output   .= '<div class="score-overlay" style="width:' . (int) min( ( $score_100 - 100 ) * -1, 100 ) . '%; background-color: ' . esc_attr( $color ) . ';"></div>';
		}
		$output .= 1 == $lets_review_format ? '<span class="cb-percent-sign">%</span>' : '';
		$output .= '</div>';
		if ( ! empty( $subtitle ) ) {
			$output .= '<div class="lets-review-subtitle">' . esc_attr( $subtitle ) . '</div>';
		}
		$output .= '</div></div>';
		return $output;
	}

	/**
	 * Get review final score
	 *
	 * @since    1.1.0
	 */
	public function lets_review_get_final_score( $pid = '' ) {

		if ( get_post_meta( $pid, '_lets_review_onoff', true ) != 1 ) {
			return;
		}

		$blocks = new Lets_Review_Blocks();
		$crits  = get_post_meta( $pid, '_lets_review_criterias', true );
		$score  = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
			array(
				'score'     => 3 == get_post_meta( $pid, '_lets_review_type', true ) ? get_post_meta( $pid, '_lets_review_user_rating', true ) : get_post_meta( $pid, '_lets_review_final_score', true ),
				'scoreType' => 3 == get_post_meta( $pid, '_lets_review_type', true ) ? 1 : get_post_meta( $pid, '_lets_review_format', true ),
			)
		);
		$args   = array(
			'padding_off' => true,
			'style_off'   => true,
			'pid'         => $pid,
			'score'       => $score,
			'scoreType'   => get_post_meta( $pid, '_lets_review_format', true ),
		);
		$args   = Lets_Review_Helpers::lets_review_args( $args );
		ob_start();
		$blocks->lets_review_score_output( $args );
		return ob_get_clean();

	}

}
